/* -----------------------------------------------------------------
   Match is made from RIGHT to LEFT

     T = CGTGCCTACTTACTTACTTACTTACGCGAA		len = n
     P =       CTTACTTAC			len = m
               ^   ^
               s   j
   ----------------------------------------------------------------- */

#include <iostream>
#include <string>

using namespace std;


int findLastPos(string s, char c)
{
   for ( int i = s.length()-1; i >= 0; i-- )
      if ( c == s[i] )
          return i;
   return -1;
}


int bm(string T, string P, int s)
{
    int n = T.length(), m = P.length();

    int j = m-1;    // Start match with character pos = m-1

    while ( s+(m-1) < n )
    {
        cout << "T: " << T << endl;
        cout << "P: ";
        for ( int z = 0; z < s; z++ ) cout << " ";
        cout << P << endl;
        cout << "   ";
        for ( int z = 0; z < s + j; z++ ) cout << " ";
        cout << "^" << endl << endl;

        if ( P[j] == T[s+j] )		// Match next character
	{
	    if ( j == 0 )
	        return(s);		// Found pattern at pos s
            j--;
	}
	else
	{
	    int lastPos = findLastPos(P, T[s+j]);
	    int shift = j - lastPos;

	    s += ( (shift >= 1) ? shift : 1 ) ;	
	    j = m-1;	// reset to 1st char to match
	}
    }
    return -1;
}

int main()
{
    string T = "abbadbaabacba";
    string P = "babacba";

    int s = -1;
    while ( (s = bm(T, P, s+1)) != -1 )
    {
        cout << P << " found at position " << s << endl;
    }
}
