/* -----------------------------------------------------------------
   Match is made from RIGHT to LEFT

     T = CGTGCCTACTTACTTACTTACTTACGCGAA		len = n
     P =       CTTACTTAC			len = m
               ^   ^
               s   j
   ----------------------------------------------------------------- */

#include <iostream>
#include <string>

using namespace std;


int goodSuffixShift(string P, int pos)
{
   string matchedSuffix = P.substr(pos+1, P.length());
   int    len = matchedSuffix.length();

   cout << "Pattern = " << P << endl;
   cout << "Good suffix = " << matchedSuffix << endl;

   // Check string  P[k] .. P[k+len-1] == matchedSuffix
   for ( int k = pos; k >= 0; k-- )
   {
      string s1 = P.substr(k, len);

      cout << "1: " << s1 << " ?== " << matchedSuffix << endl;
      if ( s1 == matchedSuffix )
          return P.length() - k - matchedSuffix.length();
   }

   // Find edge cases
   for ( int k = matchedSuffix.length()-1; k >= 1; k-- )
   {
      cout << "2: " << P.substr(0, k) << " ?== " << 
                       P.substr(P.length()-k, k) << endl;
       if ( P.substr(0,k) == P.substr(P.length()-k, P.length()) )
          return  P.length() - k;
   }

   // No suffix in P --> shift P.length()
   return P.length();
}


int bm(string T, string P, int s)
{
    int n = T.length(), m = P.length();

    int j = m-1;    // Start match with character pos = m-1

    while ( s+(m-1) < n )
    {
        cout << "T: " << T << endl;
        cout << "P: ";
        for ( int z = 0; z < s; z++ ) cout << " ";
        cout << P << endl;
        cout << "   ";
        for ( int z = 0; z < s + j; z++ ) cout << " ";
        cout << "^" << endl << endl;

        if ( P[j] == T[s+j] )		// Match next character
	{
	    if ( j == 0 )
	        return(s);		// Found pattern at pos s
            j--;
	}
	else
	{
            int shift = 1;	// Default shift

	    if ( j < m-1 )	// Make sure len(suffix) >= 1
	        shift = goodSuffixShift(P, j); // Find suffix P[j+1]..P[m-1]

	    s += shift;	
	    j = m-1;	// reset to 1st char to match
	}
    }
    return -1;
}

int main()
{
    string T = "xxxbabxabaabxabaab";
//    string P = "ccabab";
    string P = "abcbab";	// Test edge cases

    int s = -1;
    while ( (s = bm(T, P, s+1)) != -1 )
    {
        cout << P << " found at position " << s << endl;
    }
}
