/* -----------------------------------------------------------------

     T = CGTGCCTACTTACTTACTTACTTACGCGAA		len = n
     P =       CTTACTTAC			len = m
               ^   ^
               s   j
   ----------------------------------------------------------------- */

#include <iostream>
#include <string>

using namespace std;


int bruteForce(string T, string P, int s)
{
    int n = T.length(), m = P.length();

    int j = 0;	// Start match with character pos = 0

    while ( s+(m-1) < n )
    {
        cout << "T: " << T << endl;
        cout << "P: ";
        for ( int z = 0; z < s; z++ ) cout << " ";
        cout << P << endl;
        cout << "   ";
        for ( int z = 0; z < s + j; z++ ) cout << " ";
        cout << "^" << endl << endl;

        if ( P[j] == T[s+j] )		// Match next character
	{
            j++;
	    if ( j == m )
	        return(s);		// Found pattern at pos s
	}
	else
	{
	    s++;	// Use next shift
	    j = 0;	// reset to 1st char to match
	}
    }
    return -1;
}

int main()
{
    string T = "CGTGCCTACTTACTTACTTACTTACGCGAA";
    string P = "CTTACTTAC";

    int s = -1;
    while ( (s = bruteForce(T, P, s+1)) != -1 )
    {
        cout << P << " found at position " << s << endl;
    }
}
