/* -----------------------------------------------------------------
   Knutt-Morris-Pratt using MaxOverlap( ) 
   (I.e.: not precomputing the shifts...

     T = CGTGCCTACTTACTTACTTACTTACGCGAA		len = n
     P =       CTTACTTAC			len = m
               ^   ^
               s   j
   ----------------------------------------------------------------- */

#include <iostream>
#include <string>
#include <cstdlib>

using namespace std;

#define max(x,y)    ( (x>y) ? (x) : (y) )

int *KMPFailureF;

int MaxOverlap(string s)
{
   for (int k = s.length()-1; k >= 1; k--)
   {
      string s1 = s.substr(0,k);
      string s2 = s.substr(s.length()-k, s.length());
//    cout << s1 << "   " << s2 << endl;

      if ( s1 == s2 )
         return s1.length();
   }

   return 0;
}


int KMP(string T, string P, int s)
{
    int n = T.length(), m = P.length();

    int j = 0;	// Start match with character pos = 0

    while ( s+(m-1) < n )
    {
	cout << "T: " << T << endl;
	cout << "P: ";
        for ( int z = 0; z < s; z++ ) cout << " ";
	cout << P << endl;
	cout << "   ";
        for ( int z = 0; z < s + j; z++ ) cout << " ";
	cout << "^" << endl << endl;

        if ( P[j] == T[s+j] )		// Match next character
	{
            j++;
	    if ( j == m )
	        return(s);		// Found pattern at pos s
	}
	else
	{
	    string pre = P.substr(0, j);     // Does not include P[j]
	    s += max(1, pre.length() - KMPFailureF[pre.length()]); 
	    j = 0;	// reset to 1st char to match
	}
    }
    return -1;
}

int main()
{
    string T = "abacaabaccabacabaabb";
    string P = "abacab";

    // Allocate and pre-compute the KMP Failure function
    KMPFailureF = (int *)malloc( P.length() * sizeof(int) ) ;

    for ( int j = 0; j <= P.length(); j++ )
    {
       KMPFailureF[j] = MaxOverlap( P.substr(0, j) );
       cout << j << ": " << P.substr(0, j)  << " :  " << KMPFailureF[j] << endl;
    }
    cout << endl;

    // Match P on T
    int s = -1;
    while ( (s = KMP(T, P, s+1)) != -1 )
    {
        cout << P << " found at position " << s << endl;
    }
}
