
import java.util.Scanner;

public class Demo
{
  public static void main(String[] args) 
  {
    Scanner input = new Scanner(System.in);

    // (1) Prompt the user to enter the year
    System.out.print("Enter year (e.g., 2001): ");
    int year = input.nextInt();

    // (2) Prompt the user to enter the month
    System.out.print("Enter month in number between 1 and 12: ");
    int month = input.nextInt();

    // (3) Print calendar for the month of the year
    System.out.println();
    printMonth(year, month);  // This method must print the calender 
                              // for the monthof the year
  } 

  public static void printMonth(int year, int month) 
  {
     printMonthTitle(year, month);  // Need to work this out
     printMonthBody(year, month);   // Need to work this out
  }    
  
  public static void printMonthTitle(int year, int month)
  {
    System.out.println("         " + getMonthName(month)
                        + " " + year);
    System.out.println("-----------------------------");
    System.out.println(" Sun Mon Tue Wed Thu Fri Sat");
  }
  
  public static String getMonthName(int month) 
  { 
    String monthName = "";

    switch (month) 
    {
       case 1: monthName = "January";    break;
       case 2: monthName = "February";   break;
       case 3: monthName = "March";	 break;
       case 4: monthName = "April";	 break;
       case 5: monthName = "May";	 break;
       case 6: monthName = "June";	 break;
       case 7: monthName = "July";	 break;
       case 8: monthName = "August";	 break;
       case 9: monthName = "September";	 break;
       case 10: monthName = "October";	 break;
       case 11: monthName = "November";	 break;
       case 12: monthName = "December";	 break;
    }

    return monthName;
  }
  
  public static void printMonthBody(int year, int month)
  {
      int i, numDaysOnLine = 0;
    
      int startDay = getStartDay(year, month);
      int numberOfDaysInMonth = getNumberOfDaysInMonth(year, month);

      // Print startDay number of "empty" days
      for (i = 0; i < startDay; i++)
      {
         System.out.print("    ");  // Use 4 spaces for an "empty" day
         numDaysOnLine++; // Keep track of # days printed on current line 
      }

      for (i = 1; i <= numberOfDaysInMonth; i++) 
      {
         System.out.printf("%4d", i); // Print i in 4 spaces
         numDaysOnLine++; // Keep track of # days printed on current line

         if ( numDaysOnLine % 7 == 0 )// Use next line after 7 days
            System.out.println();
      }
      System.out.println();
  }
  
  public static int getStartDay(int year, int month)
  {
      final int START_DAY_FOR_JAN_1_1800 = 3; // Jan 1 1800 is Wednesday

      // Get total number of days from 1/1/1800 to month/1/year
      int totalNumberOfDays = getTotalNumberOfDays(year, month);

      // Return the start day for month/1/year
      return (totalNumberOfDays + START_DAY_FOR_JAN_1_1800) % 7;     
  }
  
  public static int getTotalNumberOfDays(int year, int month) 
  {
      int total = 0;

      // Get the total # days from 1/1/1800 to 1/1/year
      for (int i = 1800; i < year; i++)
         if (isLeapYear(i))
            total = total + 366;  // Leap year
         else
            total = total + 365;  // Normal year

      // Get the total # days from Jan/1/year to month/1/year
      for (int i = 1; i < month; i++)
         total = total + getNumberOfDaysInMonth(year, i);

      return total;
  } 
  
  public static int getNumberOfDaysInMonth(int year, int month)
  {
     int numDays = 0;
     switch (month)
     {
         case 1: numDays = 31;  break;
         case 2: numDays = isLeapYear(year) ? 29 : 28;  break;
         case 3: numDays = 31;  break;
         case 4: numDays = 30;  break;
         case 5: numDays = 31;  break;
         case 6: numDays = 30;  break;
         case 7: numDays = 31;  break;
         case 8: numDays = 31;  break;
         case 9: numDays = 30;  break;
         case 10: numDays = 31; break;
         case 11: numDays = 30; break;
         case 12: numDays = 31; break;
     }
     return numDays;      
  } 
  
  public static boolean isLeapYear(int year)
  {
     if ( year % 400 == 0 || (year % 4 == 0 && year % 100 != 0 ) )
        return true;
     else
        return false;
  }
}


