
# Column manipulations:

import pandas as pd

data = [['Alex',10],['Bob',12],['Clarke',13]]

df = pd.DataFrame(data, columns=['x','y'], index=['a','b','c'])
print("df:")
print(df)
print(df.dtypes, "\n")
print("-----------------------------")

################################
# Print rows by name
################################
print("df.loc['b']:")
print(df.loc['b'])
print("-----------------------------")

print("df.loc[ ['b','a'] ]:")
print(df.loc[ ['b','a'] ])
print("-----------------------------")

################################
# Print rows by integer index
################################
print("df.iloc[1]:")
print(df.iloc[1])
print("-----------------------------")

print("df.iloc[[1,0]]:")
print(df.iloc[[1,0]])
print("-----------------------------")

print("df.iloc[0:1]:")
print(df.iloc[0:2])
print("-----------------------------")

################################
# Add a row
################################
a = {'x':['SY'], 'y':[99]}
b = pd.DataFrame(a, index=['d'])

df = pd.concat([df, b])
print("df:")
print(df)
print("-----------------------------")

################################
# Delete a row
################################
df = df.drop('b')
print("df:")
print(df)
print("-----------------------------")

print(".iloc[1].name = ", df.iloc[1].name)
df = df.drop(df.iloc[1].name)
print("df:")
print(df)


