import numpy as np
from scipy.sparse import coo_matrix
import random
import cPickle as pickle
import string

fegoa = open('facebook/3980.egofeat', 'r')
fa = open('facebook/3980.feat', 'r')
fe = open('facebook/3980.edges', 'r')
fc = open('facebook/3980.circles', 'r')

next = fegoa.readline()
old = np.array(next.split())
# print old

next = fa.readline()
idx_list = [0]
i = 0
while next:
    i = i + 1
    # print i
    rowfeat = np.array(next.split())
    idx_list.append(rowfeat[0])
    #print rowfeat.shape
    #print old.shape
    # print rowfeat
    old = np.vstack([old, rowfeat])
    next = fa.readline()
# print i
attr = old[:, 1:old.shape[1]]
n = i
feat_dim = attr.shape[1]
feature = []
for i in range(0, n + 1):
    feature.append([])
    for j in range(0, feat_dim):
        if attr[i, j] == '1':
            feature[i].append(j+1)  # 0 for packed value

maxlen = np.max([len(vec) for vec in feature])
print maxlen
print n+1
print feat_dim

feat = []
for vec in feature:
    vec = vec + [0 for i in range(0, maxlen-len(vec))]
    feat.append(np.array(vec).reshape([maxlen, 1]))
feat = np.array(feat)
#print feat

next = fe.readline()
row = []
col = []
data = []
aj = []
for i in range(0, n + 1):
    aj.append([])

while next:
    edge = next.split()
    node1 = idx_list.index(edge[0])
    node2 = idx_list.index(edge[1])
    row.append(node1)
    col.append(node2)
    data.append(1)
    aj[node1].append(node2)
    row.append(node2)
    col.append(node1)
    data.append(1)
    # print edge[1]
    aj[node2].append(node1)
    next = fe.readline()

for i in range(1, n + 1):
    row.append('0')
    col.append(str(i))
    data.append(1)

Graph = coo_matrix((data, (row, col)), shape=(n + 1, n + 1)).toarray()

next = fc.readline()
community = []
while next:
    a = next.split()
    b = a
    for i in range(1, len(a)):
        b[i] = idx_list.index(a[i])
    #b.append(0)
    community.append(b)
    next = fc.readline()

n = Graph.shape[0]
for i in range(n):
    for j in range(n):
        if Graph[i, j] > 0:
            Graph[i, j] = 1

f1 = open('Graph.pkl', 'wb')
pickle.dump(Graph, f1)
pickle.dump(aj, f1)
f1.close()
f2 = open('feat.pkl', 'wb')
pickle.dump(feat, f2)
f2.close()
f3 = open('community.pkl', 'wb')
pickle.dump(community, f3)
f3.close()
