function [ r ] = Geodesic( X, Q, varargin)
%compute the ground truth geodesic distance using shortest path algorithm
ip = inputParser;
ip.FunctionName = 'Geodesic';
ip.addRequired('X', @ismatrix);
ip.addRequired('Q', @ismatrix);

ip.addOptional('mode', 5, @isnumeric);
ip.addOptional('W', [], @ismatrix);
ip.addOptional('k', 16, @isnumeric);
ip.addOptional('d', 2, @isnumeric);
ip.addOptional('lambda', 0, @isnumeric);
ip.parse(X, Q, varargin{:});
par = ip.Results;
mode = par.mode;
W = par.W;
k = par.k;
d = par.d;
lambda=par.lambda;
n = size(X,1);
if isempty(W)
    W=constructW(X, struct('k', k, 'bSelfConnected', false));
    for i=1:n
        for j=find(W(i,:))
           W(i,j)=EuDist2(X(i,:),X(j,:)); 
        end
    end
end

f=graphshortestpath(W,Q);
f=f';
r = [];
r.f = f;
r = computeV(X', r.f, W, lambda);
gdl_draw(X,Q,r.mats,r,mode);