function [ r ] = LE( X, Q, varargin)
%LE rank data using Laplacian Eigenmaps
time=cputime;
ip = inputParser;
ip.FunctionName = 'LE';
ip.addRequired('X', @ismatrix);
ip.addRequired('Q', @ismatrix);

ip.addOptional('mode', 5, @isnumeric);
ip.addOptional('W', [], @ismatrix);
ip.addOptional('k', 16, @isnumeric);
ip.addOptional('d', 2, @isnumeric);
ip.addOptional('lambda', 0, @isnumeric);
ip.parse(X, Q, varargin{:});
par = ip.Results;
mode = par.mode;
W = par.W;
k = par.k;
d = par.d;
lambda=par.lambda;
if isempty(W)
    W=constructW(X, struct('k', k, 'bSelfConnected', false));
end

D = diag(sum(W, 1));
L = D-W;
[eigvector, eigvalue] = eig(full(L), full(D));
eigvalue = diag(eigvalue);
[~, index] = sort(eigvalue);
eigvector = eigvector(:, index(2:2+d-1));
f = eigvector-repmat(eigvector(Q, :), size(eigvector, 1), 1);
f = f.*f;
r = [];
r.f = sqrt(sum(f, 2));
r = computeV(X', r.f, W, lambda);
gdl_draw(X,Q,r.mats,r,mode);
r.time=cputime-time;