function [ res ] = realdata(  data, gnd, varargin )
%REALDATA real data experiments
ip = inputParser;
ip.FunctionName = 'realdata';
ip.addRequired('data', @isnumeric);
ip.addRequired('gnd', @isnumeric);

ip.addOptional('k', 16, @isnumeric);  %k of k nearest neighbors
ip.addOptional('cat', 5, @isnumeric); %total num of categories %50 for Corel and 68 for PIE
%ip.addOptional('img', 42, @isnumeric);%imgs per category  %100 for Corel and 42 for PIE
ip.addOptional('algo', 7, @isnumeric);%total num of algorithms,1:gdl;2:pfrank;3:mr;4:le(svm);5:hlle;6:mvu;7:euclidean
ip.addOptional('euf', 500, @isnumeric);%use eudist to pick out top $euf results for data preparation
ip.addOptional('loops', 2, @isnumeric);%repeat for $loops times to get average %10
ip.addOptional('top', 10, @isnumeric);%get results of top $top*10 retrieval images

ip.parse(data, gnd, varargin{:});  
par = ip.Results;
%totalnum=10; %from 1 to $totalnum queries
k=par.k;
cat=par.cat;   
%img=par.img;    
algo=par.algo;    
euf=par.euf;   
loops=par.loops;  
top=par.top;      
precision=zeros(loops,cat,algo,top);
recall=zeros(loops,cat,algo,top);
ndcg=zeros(loops,cat,algo,top);
map=zeros(loops,cat,algo);

res=[];
sum=0;
bestndcg=zeros(top,1);
for i=1:(top*10)
    item=1/log2(i+1);
    sum=sum+item;
    if mod(i,10)==0
       bestndcg(i/10,1)=sum; 
    end
end

for loop=1:loops
  for i=1:cat
    loop
    i
    img = length(find(gnd==i));
    %pick out one query and do eudist
    curQ = find(gnd==i);
    preQ = curQ(1) - 1;
    Query = randi(img) + preQ;
    %Query = loop*10 + (i-1)*img;
    X = EuDist500(data,Query,euf);
    gnd1=gnd(X);
    data1=data(X,:);
    Query=1;
    qn=0;
    for j=2:euf
      if (gnd1(j)==i)
        qn=qn+1;
      end
    end
    if qn==0 
      qn=1;
    end
    %W = constructW(data1, struct('bSelfConnected', false, 'Metric','Cosine','WeightMode','Cosine'));
    %W = constructW(data1,struct('k',k,'WeightMode', 'HeatKernel'));
    W = constructW(data1,struct('k',k));
    for a=1:algo
      if a==1
        r=GR(data1, Query, 'W', W, 'mode', 0);
        f=r.f;
        [~,I]=sort(f);
      elseif a==2
        r=PR(data1, Query, 'W', W, 'mode', 0);
        f=r.f;
        [~,I]=sort(f);
      elseif a==3
        r=MR(data1, Query, 'W', W, 'mode', 0);
        f=r.f;
        [~,I]=sort(f);
      elseif a==4
        r=LE(data1, Query, 'W', W, 'mode', 0);
        f=r.f;
        [~,I]=sort(f);
      elseif a==5
        r=DisHLLE(data1, Query, 'W', W, 'mode', 0);
        f=r.f;
        [~,I]=sort(f);
%       elseif a==6
%         r=DisMVU(data1, Query, 'W', W, 'mode', 0);
%         f=r.f;
%         [~,I]=sort(f);   
      else
        I=(1:500);   
      end
      ndcgsum=0;
      right=[];
      for ten=0:top-1
        for p=1:10     %for the first pi shown picture
          if gnd1(I(ten*10+p))==i
              right=[right;I(ten*10+p)];     
              ndcgsum=ndcgsum+1/log2(ten*10+p+1);  
          end
        end
        precision(loop,i,a,ten+1)=size(right,1)/((ten+1)*10);
        recall(loop,i,a,ten+1)=size(right,1)/qn;          
        ndcg(loop,i,a,ten+1)=ndcgsum/bestndcg(ten+1,1);      
      end
      %begin map
      maps=0;
      mapright=0;
      for mapi=1:500
         if gnd1(I(mapi))==i
            mapright=mapright+1;
            maps=maps+mapright/mapi;
            if mapright==qn
                break;
            end
         end
      end
      map(loop,i,a)=maps/qn;
      %end of map
    end
  end
end

res.precision=mean(precision,1);
res.precision=mean(res.precision,2);
res.precision=reshape(res.precision,algo,top);
res.recall=mean(recall,1);
res.recall=mean(res.recall,2);
res.recall=reshape(res.recall,algo,top);
res.ndcg=mean(ndcg,1);
res.ndcg=mean(res.ndcg,2);
res.ndcg=reshape(res.ndcg,algo,top);
res.map=mean(map,1);
res.map=mean(res.map,2);
res.map=reshape(res.map,algo, 1);

end

