function Ws = multitaskFC(X_tr,Y_tr,paras,lamb)
r = paras.r;
s = paras.s;
f = paras.f;
init = true;
numKeywords = paras.f;
d = size(X_tr{1}, 2);  % dimensionality.
lambda = lamb/10 :lamb/5: lamb;
%rng('default');     % reset random generator. Available from Matlab 2011.
opts.init = 0;      % guess start point from data. 
opts.tFlag = 1;     % terminate after relative objective value does not changes much.
opts.tol = 10^-5;   % tolerance. 
opts.maxIter = 1000; % maximum iteration number of optimization.

sparsity = zeros(length(lambda), 1);
log_lam  = log(lambda);
Ws = struct([]);
for i = 1: length(lambda)
    f = numKeywords;
    [W funcVal] = Least_L21_c3(X_tr, Y_tr, s, f, lambda(i), opts);
    if init == true
        opts.init = 1;
        opts.W0 = W;
    end
    sparsity(i) = nnz(sum(W,2 )==0)/d;
    Ws(i).key = lambda(i);
    Ws(i).value = W;
end
end