function [Ws] = CMTFL_III_train(X_tr,Y_tr,conD,numD,lambda)
% This is the code for the paper:
% Liang Zhao, Qian Sun, Jieping Ye, Feng Chen, Chang-Tien Lu, and Naren 
% Ramakrishnan. “Feature Constrained Multi-Task Learnings for Event 
% Forecasting in Social Media." IEEE Transactions on Knowledge and Data 
% Engineering (TKDE), (impact factor: 3.438), vol. 29, no. 5, pp. 
% 1059-1072, May 1 2017.
% Please cite the following bibtex: 
%{
@article{zhao2017feature,
  title={Feature constrained multi-task learning models for spatiotemporal event forecasting},
  author={Zhao, Liang and Sun, Qian and Ye, Jieping and Chen, Feng and Lu, Chang-Tien and Ramakrishnan, Naren},
  journal={IEEE Transactions on Knowledge and Data Engineering},
  volume={29},
  number={5},
  pages={1059--1072},
  year={2017},
  publisher={IEEE}
}
%}
% input:
%       - numD: number of features under L01 norm constraint (i.e., W_D in
%       Equation (6) in the paper.
%       - conD: upper bound of the selected features under L01 norm
%       constraint (i.e., v in Euquation (6) in the paper.
%       lambda: regularization parameter for L21 norm.
%       Denote t as the number of tasks, d the number of features, n the 
%       number of samples.
%       X_tr: {n * d} * t - input matrix
%       Y_tr: {n * 1} * t - output matrix
% output:
%       Ws: {d*t}*l - l is the number of candidate tunning parameters
%       tried.
numFeatures = size(X_tr{1,1},2);
numTasks = size(X_tr,2);
numDates = size(X_tr{1,1},1);
paras.r = false;
paras.s = conD;
paras.f = numFeatures-numD;
X_tr1 = cell(1,numTasks);
for i=1:numTasks
    cur_X_tr = zeros(numDates,numFeatures);
    cur_X_tr(:,1:numFeatures-numD) = X_tr{1,i}(:,numD+1:end);
    cur_X_tr(:,numFeatures-numD+1:end) = X_tr{1,i}(:,1:numD);
    X_tr1{1,i} = cur_X_tr;
end
Ws = multitaskFC(X_tr1,Y_tr,paras,lambda);
Ws = Ws(end).value;